/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.features.feature.bioshroom;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RegionsUnexploredBlocks;
import net.regions_unexplored.data.tags.RegionsUnexploredTags;
import net.regions_unexplored.data.worldgen.features.feature.bioshroom.GiantBioshroomConfiguration;

public class GiantGreenBioshroomFeature
extends Feature<GiantBioshroomConfiguration> {
    public GiantGreenBioshroomFeature(Codec<GiantBioshroomConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<GiantBioshroomConfiguration> context) {
        GiantBioshroomConfiguration bioshroomConfiguration = (GiantBioshroomConfiguration)context.m_159778_();
        BlockPos pos = context.m_159777_();
        RandomSource randomSource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        int limbDirection = context.m_225041_().m_188503_(12);
        int height_main = context.m_225041_().m_188503_(bioshroomConfiguration.sizeVariation) + bioshroomConfiguration.minimumSize;
        if (!level.m_8055_(pos).m_60767_().m_76336_()) {
            return false;
        }
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            if (placeCheck == 0) {
                this.placeBase((LevelAccessor)level, (BlockPos)placePos, randomSource, bioshroomConfiguration);
            }
            if (placeCheck == height_main) {
                this.placeCap((LevelAccessor)level, (BlockPos)placePos, randomSource, bioshroomConfiguration);
            }
            this.placeStemBlock((LevelAccessor)level, (BlockPos)placePos, randomSource, bioshroomConfiguration);
            placePos.m_122173_(Direction.UP);
        }
        return true;
    }

    public void placeBase(LevelAccessor level, BlockPos pos, RandomSource randomSource, GiantBioshroomConfiguration bioshroomConfiguration) {
        Random random = new Random();
        int n = random.nextInt(2);
        int s = random.nextInt(2);
        int e = random.nextInt(2);
        int w = random.nextInt(2);
        this.placeRoot(level, pos.m_122012_(), randomSource, bioshroomConfiguration);
        this.placeRoot(level, pos.m_122019_(), randomSource, bioshroomConfiguration);
        this.placeRoot(level, pos.m_122029_(), randomSource, bioshroomConfiguration);
        this.placeRoot(level, pos.m_122024_(), randomSource, bioshroomConfiguration);
        if (n == 0) {
            this.placeStemBlock(level, pos.m_122012_().m_7494_(), randomSource, bioshroomConfiguration);
        }
        if (s == 0) {
            this.placeStemBlock(level, pos.m_122019_().m_7494_(), randomSource, bioshroomConfiguration);
        }
        if (e == 0) {
            this.placeStemBlock(level, pos.m_122029_().m_7494_(), randomSource, bioshroomConfiguration);
        }
        if (w == 0) {
            this.placeStemBlock(level, pos.m_122024_().m_7494_(), randomSource, bioshroomConfiguration);
        }
    }

    public void placeStemBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, GiantBioshroomConfiguration bioshroomConfiguration) {
        if (level.m_151570_(pos)) {
            return;
        }
        if (level.m_8055_(pos).m_60713_((Block)RegionsUnexploredBlocks.FOREST_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RegionsUnexploredBlocks.FOREST_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RegionsUnexploredBlocks.PLAINS_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RegionsUnexploredBlocks.PLAINS_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RegionsUnexploredBlocks.ALPHA_GRASS_BLOCK.get()) || level.m_8055_(pos).m_60713_(Blocks.f_50440_) || level.m_8055_(pos).m_60713_(Blocks.f_50195_)) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RegionsUnexploredBlocks.MYCOTOXIC_NYLIUM.get()) || level.m_8055_(pos).m_60713_((Block)RegionsUnexploredBlocks.GLISTERING_NYLIUM.get()) || level.m_8055_(pos).m_60713_(Blocks.f_50699_) || level.m_8055_(pos).m_60713_(Blocks.f_50690_)) {
            level.m_7731_(pos, Blocks.f_50134_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RegionsUnexploredBlocks.COBALT_NYLIUM.get())) {
            level.m_7731_(pos, Blocks.f_50730_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RegionsUnexploredBlocks.PRISMOSS.get()) || level.m_8055_(pos).m_60713_((Block)RegionsUnexploredBlocks.VIRIDESCENT_NYLIUM.get()) || level.m_8055_(pos).m_60713_((Block)RegionsUnexploredBlocks.STONE_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_50069_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RegionsUnexploredBlocks.DEEPSLATE_PRISMOSS.get()) || level.m_8055_(pos).m_60713_((Block)RegionsUnexploredBlocks.DEEPSLATE_VIRIDESCENT_NYLIUM.get()) || level.m_8055_(pos).m_60713_((Block)RegionsUnexploredBlocks.DEEPSLATE_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_152550_.m_49966_(), 2);
        } else if (GiantGreenBioshroomFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.m_7731_(pos, bioshroomConfiguration.stemProvider.m_213972_(randomSource, pos), 2);
        } else {
            return;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RegionsUnexploredBlocks.FOREST_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RegionsUnexploredBlocks.FOREST_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RegionsUnexploredBlocks.PLAINS_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RegionsUnexploredBlocks.PLAINS_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RegionsUnexploredBlocks.ALPHA_GRASS_BLOCK.get()) || level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_) || level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50195_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RegionsUnexploredBlocks.MYCOTOXIC_NYLIUM.get()) || level.m_8055_(pos.m_7495_()).m_60713_((Block)RegionsUnexploredBlocks.GLISTERING_NYLIUM.get()) || level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50699_) || level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50690_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50134_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RegionsUnexploredBlocks.COBALT_NYLIUM.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50730_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RegionsUnexploredBlocks.PRISMOSS.get()) || level.m_8055_(pos.m_7495_()).m_60713_((Block)RegionsUnexploredBlocks.VIRIDESCENT_NYLIUM.get()) || level.m_8055_(pos.m_7495_()).m_60713_((Block)RegionsUnexploredBlocks.STONE_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50069_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RegionsUnexploredBlocks.DEEPSLATE_PRISMOSS.get()) || level.m_8055_(pos.m_7495_()).m_60713_((Block)RegionsUnexploredBlocks.DEEPSLATE_VIRIDESCENT_NYLIUM.get()) || level.m_8055_(pos.m_7495_()).m_60713_((Block)RegionsUnexploredBlocks.DEEPSLATE_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_152550_.m_49966_(), 2);
        }
    }

    public void placeRoot(LevelAccessor level, BlockPos pos, RandomSource randomSource, GiantBioshroomConfiguration bioshroomConfiguration) {
        int rd = 2;
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int i = 0; i <= rd; ++i) {
            if (i > 0 && !level.m_8055_(placePos.m_7494_()).m_60713_(bioshroomConfiguration.stemProvider.m_213972_(randomSource, placePos.m_7494_()).m_60734_()) && level.m_8055_((BlockPos)placePos).m_60767_().m_76336_()) {
                return;
            }
            this.placeStemBlock(level, (BlockPos)placePos, randomSource, bioshroomConfiguration);
            placePos.m_122173_(Direction.DOWN);
        }
    }

    public void placeCap(LevelAccessor level, BlockPos pos, RandomSource randomSource, GiantBioshroomConfiguration bioshroomConfiguration) {
        Random random = new Random();
        this.placeStemBlock(level, pos, randomSource, bioshroomConfiguration);
        this.placeStemBlock(level, pos.m_122012_(), randomSource, bioshroomConfiguration);
        this.placeStemBlock(level, pos.m_122019_(), randomSource, bioshroomConfiguration);
        this.placeStemBlock(level, pos.m_122029_(), randomSource, bioshroomConfiguration);
        this.placeStemBlock(level, pos.m_122024_(), randomSource, bioshroomConfiguration);
        this.placeStemBlock(level, pos.m_7495_(), randomSource, bioshroomConfiguration);
        this.placeStemBlock(level, pos.m_7495_().m_122012_(), randomSource, bioshroomConfiguration);
        this.placeStemBlock(level, pos.m_7495_().m_122019_(), randomSource, bioshroomConfiguration);
        this.placeStemBlock(level, pos.m_7495_().m_122029_(), randomSource, bioshroomConfiguration);
        this.placeStemBlock(level, pos.m_7495_().m_122024_(), randomSource, bioshroomConfiguration);
        this.placeGlowingBlock(level, pos.m_122012_().m_122029_(), randomSource, bioshroomConfiguration);
        this.placeGlowingBlock(level, pos.m_122012_().m_122024_(), randomSource, bioshroomConfiguration);
        this.placeGlowingBlock(level, pos.m_122019_().m_122029_(), randomSource, bioshroomConfiguration);
        this.placeGlowingBlock(level, pos.m_122019_().m_122024_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122012_().m_122012_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122012_().m_122012_().m_122029_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122012_().m_122012_().m_122024_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122019_().m_122019_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122019_().m_122019_().m_122029_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122019_().m_122019_().m_122024_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122029_().m_122029_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122029_().m_122029_().m_122012_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122029_().m_122029_().m_122019_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122024_().m_122024_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122024_().m_122024_().m_122012_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_122024_().m_122024_().m_122019_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_7494_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_7494_().m_122012_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_7494_().m_122019_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_7494_().m_122029_(), randomSource, bioshroomConfiguration);
        this.placeCapBlock(level, pos.m_7494_().m_122024_(), randomSource, bioshroomConfiguration);
        if (random.nextInt(3) != 0) {
            this.placeCapBlock(level, pos.m_7494_().m_122012_().m_122029_(), randomSource, bioshroomConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeCapBlock(level, pos.m_7494_().m_122012_().m_122024_(), randomSource, bioshroomConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeCapBlock(level, pos.m_7494_().m_122019_().m_122029_(), randomSource, bioshroomConfiguration);
        }
        if (random.nextInt(3) != 0) {
            this.placeCapBlock(level, pos.m_7494_().m_122019_().m_122024_(), randomSource, bioshroomConfiguration);
        }
        this.placeGlowingBlock(level, pos.m_7495_().m_122012_().m_122012_(), randomSource, bioshroomConfiguration);
        this.placeGlowingBlock(level, pos.m_7495_().m_122012_().m_122012_().m_122029_(), randomSource, bioshroomConfiguration);
        this.placeGlowingBlock(level, pos.m_7495_().m_122012_().m_122012_().m_122024_(), randomSource, bioshroomConfiguration);
        this.placeGlowingBlock(level, pos.m_7495_().m_122019_().m_122019_(), randomSource, bioshroomConfiguration);
        this.placeGlowingBlock(level, pos.m_7495_().m_122019_().m_122019_().m_122029_(), randomSource, bioshroomConfiguration);
        this.placeGlowingBlock(level, pos.m_7495_().m_122019_().m_122019_().m_122024_(), randomSource, bioshroomConfiguration);
        this.placeGlowingBlock(level, pos.m_7495_().m_122029_().m_122029_(), randomSource, bioshroomConfiguration);
        this.placeGlowingBlock(level, pos.m_7495_().m_122029_().m_122029_().m_122012_(), randomSource, bioshroomConfiguration);
        this.placeGlowingBlock(level, pos.m_7495_().m_122029_().m_122029_().m_122019_(), randomSource, bioshroomConfiguration);
        this.placeGlowingBlock(level, pos.m_7495_().m_122024_().m_122024_(), randomSource, bioshroomConfiguration);
        this.placeGlowingBlock(level, pos.m_7495_().m_122024_().m_122024_().m_122012_(), randomSource, bioshroomConfiguration);
        this.placeGlowingBlock(level, pos.m_7495_().m_122024_().m_122024_().m_122019_(), randomSource, bioshroomConfiguration);
        this.placeCapVine(level, pos.m_7495_().m_122012_().m_122012_().m_122029_().m_122029_(), randomSource, bioshroomConfiguration);
        this.placeCapVine(level, pos.m_7495_().m_122012_().m_122012_().m_122024_().m_122024_(), randomSource, bioshroomConfiguration);
        this.placeCapVine(level, pos.m_7495_().m_122019_().m_122019_().m_122029_().m_122029_(), randomSource, bioshroomConfiguration);
        this.placeCapVine(level, pos.m_7495_().m_122019_().m_122019_().m_122024_().m_122024_(), randomSource, bioshroomConfiguration);
        this.placeCapVine(level, pos.m_7495_().m_122012_().m_122012_().m_122012_(), randomSource, bioshroomConfiguration);
        this.placeCapVine(level, pos.m_7495_().m_122012_().m_122012_().m_122012_().m_122029_(), randomSource, bioshroomConfiguration);
        this.placeCapVine(level, pos.m_7495_().m_122012_().m_122012_().m_122012_().m_122024_(), randomSource, bioshroomConfiguration);
        this.placeCapVine(level, pos.m_7495_().m_122019_().m_122019_().m_122019_(), randomSource, bioshroomConfiguration);
        this.placeCapVine(level, pos.m_7495_().m_122019_().m_122019_().m_122019_().m_122029_(), randomSource, bioshroomConfiguration);
        this.placeCapVine(level, pos.m_7495_().m_122019_().m_122019_().m_122019_().m_122024_(), randomSource, bioshroomConfiguration);
        this.placeCapVine(level, pos.m_7495_().m_122029_().m_122029_().m_122029_(), randomSource, bioshroomConfiguration);
        this.placeCapVine(level, pos.m_7495_().m_122029_().m_122029_().m_122029_().m_122012_(), randomSource, bioshroomConfiguration);
        this.placeCapVine(level, pos.m_7495_().m_122029_().m_122029_().m_122029_().m_122019_(), randomSource, bioshroomConfiguration);
        this.placeCapVine(level, pos.m_7495_().m_122024_().m_122024_().m_122024_(), randomSource, bioshroomConfiguration);
        this.placeCapVine(level, pos.m_7495_().m_122024_().m_122024_().m_122024_().m_122012_(), randomSource, bioshroomConfiguration);
        this.placeCapVine(level, pos.m_7495_().m_122024_().m_122024_().m_122024_().m_122019_(), randomSource, bioshroomConfiguration);
    }

    public void placeCapVine(LevelAccessor level, BlockPos pos, RandomSource randomSource, GiantBioshroomConfiguration bioshroomConfiguration) {
        Random random = new Random();
        int rd = random.nextInt(4);
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int i = 0; i <= rd; ++i) {
            this.placeCapBlock(level, (BlockPos)placePos, randomSource, bioshroomConfiguration);
            placePos.m_122173_(Direction.DOWN);
        }
    }

    public void placeCapBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, GiantBioshroomConfiguration bioshroomConfiguration) {
        if (level.m_151570_(pos)) {
            return;
        }
        if (GiantGreenBioshroomFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.m_7731_(pos, bioshroomConfiguration.capProvider.m_213972_(randomSource, pos), 2);
        }
    }

    public void placeGlowingBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, GiantBioshroomConfiguration bioshroomConfiguration) {
        if (level.m_151570_(pos)) {
            return;
        }
        if (GiantGreenBioshroomFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.m_7731_(pos, bioshroomConfiguration.glowBlockProvider.m_213972_(randomSource, pos), 2);
        }
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.m_204336_(RegionsUnexploredTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, GiantGreenBioshroomFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.m_204336_(RegionsUnexploredTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, GiantGreenBioshroomFeature::isReplaceableBlock);
    }
}

